/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.client.container.StorageTerminalMenu;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ClientSearchPacket
extends AbstractPacket {
    public static final CustomPacketPayload.Type<ClientSearchPacket> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("storage_search_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientSearchPacket> CODEC = StreamCodec.ofMember(ClientSearchPacket::toBytes, ClientSearchPacket::new);
    public String string;

    public ClientSearchPacket(String searchString) {
        this.string = searchString;
    }

    public ClientSearchPacket(RegistryFriendlyByteBuf pb) {
        this.string = (String)ByteBufCodecs.STRING_UTF8.decode((Object)pb);
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf pb) {
        ByteBufCodecs.STRING_UTF8.encode((Object)pb, (Object)this.string);
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer sender) {
        AbstractContainerMenu abstractContainerMenu = sender.containerMenu;
        if (abstractContainerMenu instanceof StorageTerminalMenu) {
            StorageTerminalMenu terminalScreen = (StorageTerminalMenu)abstractContainerMenu;
            terminalScreen.receiveClientSearch(sender, this.string);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

